// PDFCreatorDlg.cpp : implementation file
//

#include "stdafx.h"
#include "PDFCreator.h"
#include "PDFCreatorDlg.h"
#include "cacObject.h"
#include <afxdisp.h>


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPDFCreatorDlg dialog

#define STRLICENSETO   "Amyuni PDF Creator Evaluation"
#define STRACTIVATIONCODE  "07EFCDAB010001004282943FD9F19A88F332D9E7816403607A6D79A42847A1BDE06DB61C1BE94E2D90424BF876238A335F9D3084E9FC"


TCHAR currentDir[MAX_PATH];

CPDFCreatorDlg::CPDFCreatorDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPDFCreatorDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPDFCreatorDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CPDFCreatorDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPDFCreatorDlg)
	DDX_Control(pDX, IDC_PDFCREACTIVEX1, m_PDF);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CPDFCreatorDlg, CDialog)
	//{{AFX_MSG_MAP(CPDFCreatorDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BTN_OPEN, OnBtnOpen)
	ON_BN_CLICKED(IDC_BTN_CREATE_OBJECT, OnBtnCreateObject)
	ON_BN_CLICKED(IDC_BTN_CHANGE_OBJECT, OnBtnChangeObject)
	ON_BN_CLICKED(IDC_BTN_LOAD_FROM_STREAM, OnBtnLoadFromStream)
	ON_BN_CLICKED(IDC_BTN_ADD_PIC_OBJECT, OnBtnAddPicObject)
	ON_BN_CLICKED(IDC_BTN_REACHTEXT, OnBtnReachtext)
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDOK, &CPDFCreatorDlg::OnBnClickedOk)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPDFCreatorDlg message handlers

BOOL CPDFCreatorDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here

	//*****Set the licensing information here*****//
	m_PDF.SetLicenseKey( STRLICENSETO, STRACTIVATIONCODE);

	
	GetCurrentDirectory( MAX_PATH, currentDir );
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CPDFCreatorDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CPDFCreatorDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

////////////////////////////////////////////////////////////////////////////
//This sample illustrates how to open and render a PDF document on the PDF Creator control
void CPDFCreatorDlg::OnBtnOpen() 
{
	try
	{
		CString csPath = currentDir;
		m_PDF.Open (_T(csPath + "\\Source_Docs\\OnBtnOpen.pdf"), "");
	}
	catch( CException* e )
	{
		
		TCHAR szCause[255];
		CString strFormat;

		 e->GetErrorMessage(szCause, 255);

		strFormat = _T("The data file could not be opened because of this error: ");
		strFormat += szCause;

		AfxMessageBox (strFormat);
		e->Delete ();

	}
}


////////////////////////////////////////////////////////////////////////////
// This function illustrates how to create an object
// and add it to a PDF document
void CPDFCreatorDlg::OnBtnCreateObject() 
{
	//This is typically done on a form load
	//m_PDF.SetLicenseKey(STRLICENSETO, STRACTIVATIONCODE);

	//NOTE: test document included with sample
	CString csPath = currentDir;
	m_PDF.Open (_T(csPath + "\\Source_Docs\\5pagedoc.pdf"), "");

	//Go to page number 3
	m_PDF.put_CurrentPage ( 3 );

	//Go into design mode
	//to add PDF object
	m_PDF.put_ReportState (1);

	VARIANT var;
	var.vt = VT_I4;
	var.lVal = 0;

	CString cs ="add text here";
	VARIANT varStr;
	varStr.vt = VT_BSTR;
	varStr.bstrVal = cs.AllocSysString();

	//Create an acObjectTypeText object and give it a myTextobject name
	m_PDF.CreateObject ( 5 , "myTextobject");

	//Positioning object
	m_PDF.put_ObjectAttribute ("myTextobject", "Left", var);
	m_PDF.put_ObjectAttribute ("myTextobject", "Top", var);

	var.lVal = 1000;	
	m_PDF.put_ObjectAttribute ("myTextobject", "Right", var);
	m_PDF.put_ObjectAttribute ("myTextobject", "Bottom", var);

	//adding text attribute
	m_PDF.put_ObjectAttribute ("myTextobject", "Text", varStr);

	VARIANT varcolor;
	varcolor.vt = VT_I4;
	varcolor.lVal = 0x00FF0000;
	m_PDF.put_ObjectAttribute("myTextobject", "BackColor", varcolor);  // This will change BackColor

	//Apply changes by going into run mode
    m_PDF.put_ReportState (0); 

	//Save new file
	//1: acFileSaveView
	m_PDF.Save (csPath + "\\Resulting_Docs\\OnBtnCreateObject_example.pdf", 1);

}


////////////////////////////////////////////////////////////////////////////
// This function illustrates how to access an object using its name property 
// and changing its text value
void CPDFCreatorDlg::OnBtnChangeObject() 
{
	//This is typically done on a form load
	//m_PDF.SetLicenseKey(STRLICENSETO, STRACTIVATIONCODE);

	//NOTE: test document included with sample
	CString csPath = currentDir;
	m_PDF.Open (_T(csPath + "\\Source_Docs\\OnBtnChangeObject.pdf"), "");

	AfxMessageBox ("Text will be changed in PDF document", NULL);

	//Put control into design mode
	m_PDF.put_ReportState (1);

	//Turn off AutoRefresh
	//This reduces the "Flicker" on the control
	m_PDF.put_AutoRefresh (1);

	//Retrieve object based on name
	//add error checking in case name does not exist
	CacObject obj = m_PDF.GetObjectByName("My_acObjectName");


	VARIANT var;
	var.vt = VT_I4;
	var.lVal = 0x00FF0000;
	obj.put_Attribute("BackColor", var);  // This will change BackColor

	CString cs;
	cs = "The text has been changed";
	VARIANT varStr;
	varStr.vt = VT_BSTR;
	varStr.bstrVal = cs.AllocSysString();

	obj.put_Attribute("Text", varStr );  // This will change Text Value
     
	//Apply changes
    m_PDF.DoCommandTool(53776); 

	//Save new file
	m_PDF.Save (csPath + "\\Resulting_Docs\\OnBtnChangeObject_example.pdf", 1);
	
	//Turn on AutoRefresh
	m_PDF.put_AutoRefresh (0);

	//NOTE: test document included with sample
	m_PDF.Open (csPath + "\\Resulting_Docs\\OnBtnChangeObject_example.pdf", ""); 

}

COLORREF CPDFCreatorDlg::changecolor(CString strclor)
{
	return 0;
}




////////////////////////////////////////////////////////////////////////////////////////
/*
This function illustrates how to load a PDF document from a memory stream and display 
it on the Amyuni PDF Creator Control.
*/
void CPDFCreatorDlg::OnBtnLoadFromStream() 
////////////////////////////////////////////////////////////////////////////////////////
{
	IStream *inputStream = NULL;
	IPersistStreamInit *pdfStream = NULL;

	//This is typically done on a form load
	//m_PDF.SetLicenseKey(STRLICENSETO, STRACTIVATIONCODE);

	// m_pdfControl is the object associated with the PDF control
	m_PDF.GetControlUnknown()->QueryInterface( IID_IPersistStreamInit, (void **)&pdfStream );
	
	// for testing, load a PDF file into memory, then send it to Creator
	CString csPath = currentDir;
	CFile	inFile( _T(csPath + "\\Source_Docs\\OnBtnLoadFromStream.pdf"), CFile::modeRead );


	// hg is the handle to the memory where the PDF data resides
	HGLOBAL	hg = GlobalAlloc( GHND, inFile.GetLength() );
	inFile.Read( GlobalLock( hg ), inFile.GetLength() );
	GlobalUnlock( hg );
	CreateStreamOnHGlobal( hg, TRUE, &inputStream );

	// load the PDF control from the memory object
	pdfStream->Load( inputStream );
	inputStream->Release();
	pdfStream->Release();

	//** Save contents in of PDF Creator to memory stream.
	
	// save the PDF to another memory buffer
	ULARGE_INTEGER	size;
	IStream *outputStream = NULL;
	IPersistStreamInit *pdfStream2 = NULL;

	// m_pdfControl is the object associated with the PDF control
	m_PDF.GetControlUnknown()->QueryInterface( IID_IPersistStreamInit, (void **)&pdfStream2 );
	pdfStream2->GetSizeMax( &size );	// get the size

	// hg1 is the handle to the memory where the PDF data will reside
	HGLOBAL	hg1 = GlobalAlloc( GHND, size.LowPart );
	CreateStreamOnHGlobal( hg1, FALSE, &outputStream );
	pdfStream2->Save( outputStream, TRUE );
	outputStream->Release();
	LPBYTE	pdfData = (LPBYTE)GlobalLock( hg1 );

 
	CFile file;
	file.Open (_T (csPath + "\\Resulting_Docs\\OnBtnLoadFromStream_tostream.pdf"), CFile::modeCreate | 
                        CFile::modeWrite | CFile::shareDenyWrite );

	file.Write (pdfData, (unsigned int)size.QuadPart );
    file.Close ();
	// ....
	GlobalUnlock( hg1 );
	m_PDF.Refresh();
}

//This function illustrates how to add picture objects to the PDF Creator control
void CPDFCreatorDlg::OnBtnAddPicObject() 
{
	//This is typically done on a form load
	//m_PDF.SetLicenseKey(STRLICENSETO, STRACTIVATIONCODE);

	CString csPath = currentDir;
	m_PDF.Open (csPath + "\\Source_Docs\\OnBtnAddPicObject.pdf", ""); 


	VARIANT var;
	var.vt = VT_I4;
	var.lVal = 0;


	CString cs = csPath + "\\Source_Docs\\pdfcreatoractivex.png";

	VARIANT varStr;
	varStr.vt = VT_BSTR;
	varStr.bstrVal = cs.AllocSysString();

	//create a field object
	m_PDF.CreateObject ( 7 , "acObjectPicture");

	//Position
	m_PDF.put_ObjectAttribute ("acObjectPicture", "Left", var);
	m_PDF.put_ObjectAttribute ("acObjectPicture", "Top", var);

	var.lVal = 1000;	
	m_PDF.put_ObjectAttribute ("acObjectPicture", "Right", var);
	m_PDF.put_ObjectAttribute ("acObjectPicture", "Bottom", var);

	VARIANT varcolor1;
	varcolor1.vt = VT_I4;
	varcolor1.lVal = 0x00FFFFFF;
	m_PDF.put_ObjectAttribute ("acObjectPicture", "RGBMask", varcolor1);

	m_PDF.put_ObjectAttribute ("acObjectPicture", "FileName", varStr);

	VARIANT var1;
	VariantInit ( &var1 );
	var1.vt = VT_I4;
	var1.lVal = 1200;

	CString cs1 = csPath + "\\Source_Docs\\pdfconverter.png";
	VARIANT varStr1;
	varStr1.vt = VT_BSTR;
	varStr1.bstrVal = cs1.AllocSysString();

	//create a field object
	m_PDF.CreateObject ( 7 , "acObjectPicture1");

	m_PDF.put_ObjectAttribute ("acObjectPicture1", "Left", var1);
	m_PDF.put_ObjectAttribute ("acObjectPicture1", "Top", var1);

	VariantInit ( &var1 );
	var1.vt = VT_I4;

	var1.lVal = 2500;	
	m_PDF.put_ObjectAttribute ("acObjectPicture1", "Right", var1);
	m_PDF.put_ObjectAttribute ("acObjectPicture1", "Bottom", var1);
	m_PDF.put_ObjectAttribute ("acObjectPicture1", "FileName", varStr1);
	
	//add RGBMask mask	
	VARIANT varcolor;
	varcolor.vt = VT_I4;
	varcolor.lVal = 0x00FFFFFF;
	m_PDF.put_ObjectAttribute ("acObjectPicture1", "RGBMask", varcolor);


	//Apply changes
    m_PDF.DoCommandTool(53776); 

	//Save new file
	m_PDF.Save (csPath + "\\Resulting_Docs\\OnBtnAddPicObject_example.pdf", 1);
}

////////////////////////////////////////////////////////////////////////////////////////
/*
The ReachTextEx function reaches a text object having a specified text and font attributes. This is the same as the
ReachText function except that it returns the object reference if the text is found, an empty string otherwise.
*/
////////////////////////////////////////////////////////////////////////////////////////
void CPDFCreatorDlg::OnBtnReachtext() 
{	
	//This is typically done on a form load
	//m_PDF.SetLicenseKey(STRLICENSETO, STRACTIVATIONCODE);

	CString csPath = currentDir;
	m_PDF.Open (_T(csPath + "\\Source_Docs\\5pagedoc.pdf"), "");

	//Goto page 2
	m_PDF.put_CurrentPage ( 2 );


	//Search for this text string
	//It returns the object reference if the text is found, an empty string otherwise.
	CString csFoundText  = m_PDF.ReachTextEx(1, _T("Page"), _T(""),0,0,0 );

	//Error checking that text was found
	if ( csFoundText.GetLength() != 0)
	{

		VARIANT var;
		var.vt = VT_I4;
		var.lVal = 0x00FF0000;
		m_PDF.put_ObjectAttribute (csFoundText, "BackColor", var);  // This will change BackColor
		

		CString cs;
		cs = "Found It!";
		VARIANT varStr;
		varStr.vt = VT_BSTR;
		varStr.bstrVal = cs.AllocSysString();
	 
		m_PDF.put_ObjectAttribute (csFoundText, "Text", varStr);// This will change Text Value
	     
		//Apply changes
		m_PDF.DoCommandTool(53776); 

		//Save new file
		m_PDF.Save (csPath + "\\Resulting_Docs\\OnBtnReachtext_example.pdf", 1);
	}
	
	
}

void CPDFCreatorDlg::OnBnClickedOk()
{
	// TODO: Add your control notification handler code here
	OnOK();
}
